//＜操作＞
//カーソル左右で表示月を変更
//春分秋分の日は異なることがある
//＜休日ファイルはdataフォルダ内にある＞
StringList readLines;  // 休日データ
PFont myFont;          // 使用するフォント
int ts = 17;           // 文字の大きさ 
int year = year();     // 表示年
int month = month();   // 表示月

void setup(){
  size(310,200);
  readLines = new StringList();
  myFont = createFont("arial",30);
  //myFont = createFont("Osaka",30);
  fileRead();
}
void draw(){
  background(0);  
    textAlign(CENTER, CENTER);
  textFont(myFont);
  textSize(ts);
  title();
  days();
}
// --------------------------------
// 年月と曜日を書く
// --------------------------------
void title(){
  fill(255);textSize(ts);
  String ym = str(year)+" 年 ";
  ym += str(month)+" 月";
  text(ym,ts*9,ts*1.5);
  String w = "日 月 火 水 木 金 土"; 
  String[] wd = split(w,' '); 
  stroke(255);
  int py = int(ts*3.7);
  line(ts*2,py,ts*16,py);
  stroke(120);
  line(ts*10,ts*3,ts*10,ts*9);
  for(int i=0;i<7;i++){
    int px = ts+ts*2*(i+1);
    text(wd[i],px,ts*3);
  }
  //redNum("日",ts*3,ts*3);
}
// --------------------------------
// カレンダー本体を書く
// --------------------------------
void days(){
  int sy = youbi(year,month,1); // 1日の曜日
  int ed = endDay(year,month);  // 月末日
  int[] hd = holiday();         // 休日
  int n = 0;    // 表示日
  for(int i=0;i<38;i++){
    n = i - sy + 1;
    if(n < 1) continue;
    if(n > ed) break;
    int px = ts+ts*2*(i%7+1);
    int vs = int(ts*1.2); 
    int py = int(ts*4.5)+vs*(i/7);
    boolean hDay = false;          // 休日の確認
    for(int h:hd)if(h  ==n)hDay = true;
    if(i%7==0 || hDay)redNum(str(n),px,py);
    else whtNum(n,px,py);
  }
}
// --------------------------------
// 赤字を描く
// --------------------------------
void redNum(String n,int px,int py){
  textAlign(CENTER, CENTER);
  fill(255);
  text(n,px+1,py+1);
  text(n,px-1,py+1);
  text(n,px+1,py-1);
  text(n,px-1,py-1);
  // ---------
  fill(255,0,0);
  //fill(255);
  text(n,px,py);
}

// --------------------------------
// 白字を描く
// --------------------------------
void whtNum(int n,int px,int py){
  fill(255);
  text(n,px,py);
}
// -----------------------------------------------
// 指定月の最終日付曜日を計算　
// -----------------------------------------------
int endDay(int y, int m){
  int[] md = {31,28,31,30,31,30,31,31,30,31,30,31 };
  int ed = md[m-1];
  if(m ==2 && y%4 == 0) ed = 29;
  return ed;
}
// -----------------------------------------------
// ツェラーの公式 日付から曜日を計算　日曜:0 - 土曜:6
// -----------------------------------------------
int youbi(int y, int m, int d){
  int[] mVal = {0,3,2,5,0,3,5,1,4,6,2,4};
  if (m < 3) y--;
  int dayWeek = d+mVal[m-1];
  dayWeek += y+y/4-y/100+y/400;
  return dayWeek % 7;
}
// --------------------------
// 表示月の代休を反映した休日を配列で返す
// --------------------------
int[] holiday(){
  if(month == 5)return holiday5();
  else return holiday0();
}
// 5月だけ特別処理　５日が日月火なら６日は休日
int[] holiday5(){
  int[] hd = {3,4,5,0,0};
  int y = youbi(year,month,5);
  if(y < 3)hd[3] = 6;
  return hd;  
}
// 5月以外の処理
int[] holiday0(){
  int[] hd = {0,0,0,0,0};int n = 0;
  for(String i :readLines){
    String[] md = split(i,",");
    if(int(md[0]) == month){  // 表示月なら
      int d = int(md[1]);
      if(d>0){
        int y = youbi(year,month,d); // 休日の曜日
        if(y==0)d++;
      }else {
        d = monday(abs(d));
      }
      hd[n] = d;
      n++;
    }  // end 表示月
  }  // end for 
  return hd;
}

// --------------------------
// 第n月曜の日にち
// --------------------------
int monday(int n){
  int sy = youbi(year,month,1); // 1日の曜日
  return (8-sy)%7+1+(n-1)*7;
}
// --------------------------
// 祝日をファイルから読み出す
// --------------------------
void fileRead() {
  String filename = "holiday.txt";
  String[] rLines = loadStrings(filename);
  for(String i : rLines){
    String s = getDays(i);
    if(s != "") readLines.append(s);
  }
}
// --------------------------
// ファイル情報の解釈
// --------------------------
String getDays(String str){
  String[] m1 = match(str,"([0-9]+)月");
  if(m1 == null) return "";
  String res = m1[1] + ",";
  String[] m2 = match(str,"([0-9]+)日");
  if(m2 != null) res += m2[1]; 
  else{
    m2 = match(str,"第([0-9])月曜");
    if(m2 != null) res += "-"+m2[1];
  }
  return res;
}
// --------------------------
// keyPressed
// --------------------------
void keyPressed(){
  if(keyCode == RIGHT){month ++;
    if(month > 12){ month = 1;year ++;}}
  else if(keyCode == LEFT){month --;
    if(month < 1){ month = 12;year --;} }
  else if(key == ' '){
    println(":::");
    for(String s:readLines)
    println(s);
  }
}
